<?php
require_once("functions.inc.php");
Control_SESSION_USER();
require('fpdf.php');
class PDF extends FPDF {
//Pied de page
function Footer(){
    $this->SetY(-15);
    $this->SetFont('Arial','I',8);
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    $a = date('d/m/Y H:i:s');
	$this->Cell(0,10,'Date '.$a,0,0,'R');
}
}

  $pfs = get_mes_portefeuilles();
  /* --------------------------------- */
  for($pi=0;$pi<count($pfs);$pi++)
	{
	$porte_feuille = get_a_portefeuille($pfs[$pi]['PFID']);
	$lignepf = get_SQL("SELECT L.*, T.TISIN, T.TTYPE, T.TURL, TCCLOTURE, T.TCFORMAT, T.TNOM, T.TCCOURS, T.TCVARJ, T.TCVOLU, T.TCPHAUT, T.TCPBAS, T.TCCLOTUREVEILLE, T.TCTIME FROM ligne_portefeuille L, titre T WHERE L.PFID='".$pfs[$pi]['PFID']."' AND L.TID=T.TID ORDER BY L.LPNUML ASC, T.TNOM ASC");
	$total['tpnow']=0;
	$total['evoj']=0;
	$total['pmvL']=0;
	for($i=0;$i<count($lignepf);$i++)
  		{
		$lignepf[$i]['LPQTE'] = sprintf($lignepf[$i]['LPQTEFORMAT'],$lignepf[$i]['LPQTE']);

		if($lignepf[$i]['LPDDETACH']=='0000-00-00') 
			{ $lignepf[$i]['LPDDETACH']=""; }
		else{ 
			$lignepf[$i]['LPDDETACH'] =	date("d/m/y",strtotime($lignepf[$i]['LPDDETACH']));
			}
		$lignepf[$i]['ampl'] = 0;
		$lignepf[$i]['cours'] = sprintf($lignepf[$i]['TCFORMAT'],$lignepf[$i]['TCCOURS']);
		$lignepf[$i]['cloture'] = $lignepf[$i]['TCCLOTURE'];
		$lignepf[$i]['valeur'] = sprintf('%.0f',$lignepf[$i]['TCCOURS']*$lignepf[$i]['LPQTE']);
		$lignepf[$i]['pmv_prc'] = '-';
		if($lignepf[$i]['LPPAM']!=0)
			{
			$lignepf[$i]['pmv_prc'] = sprintf('%.2f',(($lignepf[$i]['TCCOURS']/$lignepf[$i]['LPPAM'])-1)*100);
			}
		$lignepf[$i]['pmv_euro'] = sprintf('%.0f',($lignepf[$i]['LPQTE']*($lignepf[$i]['TCCOURS']-$lignepf[$i]['LPPAM'])));
		$lignepf[$i]['valeur_achat'] = $lignepf[$i]['LPPAM']*$lignepf[$i]['LPQTE'];
		$lignepf[$i]['varj'] =  sprintf('%.2f',$lignepf[$i]['TCVARJ']);
  		$lignepf[$i]['volume'] = $lignepf[$i]['TCVOLU'];
		$lignepf[$i]['plus_haut'] =  sprintf($lignepf[$i]['TCFORMAT'],$lignepf[$i]['TCPHAUT']);
 		$lignepf[$i]['plus_bas'] =  sprintf($lignepf[$i]['TCFORMAT'],$lignepf[$i]['TCPBAS']);
		if($lignepf[$i]['TCPBAS']!=0)
			{ 
			$lignepf[$i]['ampl'] = sprintf('%.2f',($lignepf[$i]['TCPHAUT']-$lignepf[$i]['TCPBAS'])*100/$lignepf[$i]['TCPBAS']);
			}
		$lignepf[$i]['ouverture'] =  sprintf($lignepf[$i]['TCFORMAT'],$lignepf[$i]['TCOUVERTURE']);
		$lignepf[$i]['cloture_veille'] =  sprintf($lignepf[$i]['TCFORMAT'],$lignepf[$i]['TCCLOTUREVEILLE']);
		$lignepf[$i]['evoj'] = 0;
		if($lignepf[$i]['TTYPE']!='F')
			{
			$lignepf[$i]['evoj'] = sprintf('%.0f',($lignepf[$i]['TCCOURS']-$lignepf[$i]['TCCLOTUREVEILLE'])*$lignepf[$i]['LPQTE']);
			}
 		$lignepf[$i]['datetime'] = $lignepf[$i]['TCDATETIME'];
		$lignepf[$i]['time'] = $lignepf[$i]['TCTIME'];
  		$total['pmvL']=$total['pmvL'] + $lignepf[$i]['pmv_euro'];
		$total['tpnow']=$total['tpnow'] + $lignepf[$i]['valeur'];
		$total['evoj']= $total['evoj'] + $lignepf[$i]['evoj'];
  		}
  for($i=0;$i<count($lignepf);$i++)
	{
	$lignepf[$i]['prc_port'] = sprintf('%.2f',$lignepf[$i]['valeur']*100/$total['tpnow']);
	}
  $total['tpnow'] = sprintf('%.0f',$total['tpnow']+$porte_feuille['PFLIQUID']);
  $total['tpretrait'] = get_a_sum_retrait($pfs[$pi]['PFID']);
  $porte_feuille['PFV3112'] = 0;
  if($porte_feuille['PF3112']!=0)
  	{
  	$porte_feuille['PFV3112'] =  sprintf('%.2f',($total['tpnow'] + $total['tpretrait'] - $porte_feuille['PF3112']) * 100 / $porte_feuille['PF3112']);
	}
  $total['tpveille']=$total['tpnow']- $total['evoj'];
  if($total['tpveille']!=0)
  	{
  	$porte_feuille['PFVJ'] = sprintf('%.2f',(100*$total['evoj'] / $total['tpveille']));
	}

/*  -------------- Indices  etc------------------*/
$indices = get_indices();
$reperes_eco = get_reperes_eco();
$changes = get_changes();
$echiquier = get_echiquier();

//Instanciation de la classe drive
if ($pi==0) { 
$pdf=new PDF(); 
$pdf->SetMargins(5,5); 
$pdf->AliasNbPages();
}

$pdf->AddPage('L');
$my_x = $pdf->GetX();
$my_y = $pdf->GetY();

$w = array(23,14,14,14,14);
$pdf->SetFont('Arial','B',7);
$pdf->SetFillColor(255, 245, 155);
$pdf->Cell($w[0],3,'Indices','LRTB',0,'R',1);
$pdf->Cell($w[1],3,'Cours','LRTB',0,'L',1);
$pdf->Cell($w[2],3,'C.31/12','LRTB',0,'C',1);
$pdf->Cell($w[3],3,'%.31/12','LRTB',0,'R',1);
$pdf->Cell($w[4],3,'%.Jour','LRTB',0,'R',1);
$pdf->Ln();
$pdf->SetFont('Arial','',7);
$pdf->SetFillColor(220, 220, 220);
for($i=0;$i<count($indices);$i++)
    {
	$borders = 'LR';
	if ($i+1==count($indices)) { $borders = 'LRB'; }
	$pdf->Cell($w[0],3,utf8_decode($indices[$i]['INDNOM']),$borders,0,'R',$i%2);
	$pdf->Cell($w[1],3,$indices[$i]['INDCCOURS'].$indices[$i]['INDCCLOTURE'],$borders,0,'L',$i%2);
	$pdf->Cell($w[2],3,$indices[$i]['INDC3112'],$borders,0,'R',$i%2);
	if($indices[$i]['INDV3112']<0) { $pdf->SetTextColor(220, 0, 0); }
	else { $pdf->SetTextColor(0, 220, 0); }
	$pdf->Cell($w[3],3,$indices[$i]['INDV3112'].'%',$borders,0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);
	if($indices[$i]['INDCVAR']<0) { $pdf->SetTextColor(220, 0, 0); }
	else { $pdf->SetTextColor(0, 220, 0); }
	$pdf->Cell($w[4],3,$indices[$i]['INDCVAR'].'%',$borders,0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);
	$pdf->Ln();
	}
$p_x = $pdf->GetX();
$p_y = $pdf->GetY();

$pdf->SetXY($my_x+85,$my_y);
$w = array(23,14,14);
$pdf->SetFont('Arial','B',7);
$pdf->SetFillColor(255, 245, 155);
$pdf->Cell($w[0],3,'Repres Eco.','LRTB',0,'R',1);
$pdf->Cell($w[1],3,'Cours','LRTB',0,'R',1);
$pdf->Cell($w[2],3,'%.31/12','LRTB',0,'R',1);

$pdf->SetFont('Arial','',7);
$pdf->SetFillColor(220, 220, 220);
for($i=0;$i<count($reperes_eco);$i++)
    {
	$pdf->SetXY($my_x+85,$my_y+($i+1)*3);
	$borders = 'LR';
	if ($i+1==count($reperes_eco)) { $borders = 'LRB'; }
	$pdf->Cell($w[0],3,utf8_decode($reperes_eco[$i]['RENOM']),$borders,0,'R',$i%2);
	$pdf->Cell($w[1],3,$reperes_eco[$i]['RECCOURS'].$reperes_eco[$i]['RECCLOTURE'],$borders,0,'R',$i%2);
	$pdf->Cell($w[2],3,$reperes_eco[$i]['REV3112'].'%',$borders,0,'R',$i%2);
	}
	
$pdf->SetXY($my_x+138,$my_y);
$w = array(23,14,14,14);
$pdf->SetFont('Arial','B',7);
$pdf->SetFillColor(255, 245, 155);
$pdf->Cell($w[0],3,'Changes','LRTB',0,'R',1);
$pdf->Cell($w[1],3,'Cours','LRTB',0,'R',1);
$pdf->Cell($w[2],3,'C.31/12','LRTB',0,'R',1);
$pdf->Cell($w[2],3,'%.31/12','LRTB',0,'R',1);

$pdf->SetFont('Arial','',7);
$pdf->SetFillColor(220, 220, 220);
for($i=0;$i<count($changes);$i++)
    {
	$pdf->SetXY($my_x+138,$my_y+($i+1)*3);
	$borders = 'LR';
	if ($i+1==count($changes)) { $borders = 'LRB'; }
	$pdf->Cell($w[0],3,utf8_decode($changes[$i]['CHNOM']),$borders,0,'R',$i%2);
	$pdf->Cell($w[1],3,$changes[$i]['CHCCOURS'],$borders,0,'R',$i%2);
	$pdf->Cell($w[2],3,$changes[$i]['CHC3112'],$borders,0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);
	if($changes[$i]['CHV3112']<0) { $pdf->SetTextColor(220, 0, 0); }
	$pdf->Cell($w[3],3,$changes[$i]['CHV3112'].'%',$borders,0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);
	}
	
	
$pdf->SetXY($my_x+205,$my_y);
$w = array(23,14,14,14);
$pdf->SetFont('Arial','B',7);
$pdf->SetFillColor(255, 245, 155);
$pdf->Cell($w[0],3,'Echiquier','LRTB',0,'R',1);
$pdf->Cell($w[1],3,'Cours','LRTB',0,'R',1);
$pdf->Cell($w[2],3,'C.31/12','LRTB',0,'R',1);
$pdf->Cell($w[2],3,'%.31/12','LRTB',0,'R',1);

$pdf->SetFont('Arial','',7);
$pdf->SetFillColor(220, 220, 220);
for($i=0;$i<count($echiquier);$i++)
    {
	$pdf->SetXY($my_x+205,$my_y+($i+1)*3);
	$borders = 'LR';
	if ($i+1==count($echiquier)) { $borders = 'LRB'; }
	$pdf->Cell($w[0],3,utf8_decode($echiquier[$i]['ECHNOM']),$borders,0,'R',$i%2);
	$pdf->Cell($w[1],3,$echiquier[$i]['ECHCVAL'],$borders,0,'R',$i%2);
	$pdf->Cell($w[2],3,$echiquier[$i]['ECHC3112'],$borders,0,'R',$i%2);
	$pdf->Cell($w[3],3,$echiquier[$i]['ECHV3112'].'%',$borders,0,'R',$i%2);
	}
	
$pdf->SetXY($p_x,$p_y+1);
$pdf->SetFillColor(255, 245, 155);
$pdf->SetFont('Arial','B',10);
$pdf->Cell(50,5,utf8_decode($porte_feuille['PFNAME']),1,0,'C',1);
$pdf->Cell(100,5,'Date : '.date('d/m/Y'),1,0,'C',0);
$pdf->Cell(125,5,utf8_decode($porte_feuille['PFBANQUE']),1,0,'R',1);
$pdf->Ln();

$w = array(14,42,23,14,14,14,14,14,14,14,14,14,14,14,14,14,14);

$pdf->SetFont('Arial','B',8);
$pdf->SetFillColor(255, 245, 155);
$pdf->Cell($w[0],4,'Quantit','LRTB',0,'R',1);
$pdf->Cell($w[1],4,'Nom','LRTB',0,'L',1);
$pdf->Cell($w[2],4,'Code Valeur','LRTB',0,'C',1);
$pdf->Cell($w[3],4,'PAM','LRTB',0,'R',1);
$pdf->Cell($w[4],4,'Cours','LRTB',0,'R',1);
$pdf->Cell($w[5],4,'valeur','LRTB',0,'R',1);
$pdf->Cell($w[6],4,'pmv %','LRTB',0,'R',1);
$pdf->Cell($w[7],4,'pmv ','LRTB',0,'R',1);
$pdf->Cell($w[8],4,'% Port.','LRTB',0,'R',1);
$pdf->Cell($w[9],4,'Var. j','LRTB',0,'R',1);
$pdf->Cell($w[10],4,'+haut j','LRTB',0,'R',1);
$pdf->Cell($w[11],4,'+bas j','LRTB',0,'R',1);
$pdf->Cell($w[12],4,'%ampl j','LRTB',0,'R',1);
$pdf->Cell($w[13],4,'volume j','LRTB',0,'R',1);
$pdf->Cell($w[14],4,'Evol. j','LRTB',0,'R',1);
$pdf->Cell($w[15],4,'Div ','LRTB',0,'R',1);
$pdf->Cell($w[16],4,'Date','LRTB',0,'R',1);
$pdf->Ln();
$pdf->SetFont('Arial','',8);
$pdf->SetFillColor(220, 220, 220);
for($i=0;$i<count($lignepf);$i++)
    {
	$pdf->Cell($w[0],4,$lignepf[$i]['LPQTE'],'LR',0,'R',$i%2);
	$pdf->Cell($w[1],4,utf8_decode($lignepf[$i]['TNOM']),'LR',0,'L',$i%2);
	$pdf->Cell($w[2],4,$lignepf[$i]['TISIN'],'LR',0,'R',$i%2);
	$pdf->Cell($w[3],4,$lignepf[$i]['LPPAM'],'LR',0,'R',$i%2);
	$pdf->Cell($w[4],4,$lignepf[$i]['cours'].$lignepf[$i]['TCCLOTURE'],'LR',0,'R',$i%2);
	$pdf->Cell($w[5],4,$lignepf[$i]['valeur'],'LR',0,'R',$i%2);
	if($lignepf[$i]['pmv_prc']<0) { $pdf->SetTextColor(220, 0, 0); }
	$pdf->Cell($w[6],4,$lignepf[$i]['pmv_prc']."%",'LR',0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);	
	if($lignepf[$i]['pmv_euro']<0) { $pdf->SetTextColor(220, 0, 0); }
	$pdf->Cell($w[7],4,$lignepf[$i]['pmv_euro'],'LR',0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);	
	$pdf->Cell($w[8],4,$lignepf[$i]['prc_port'],'LR',0,'R',$i%2);
	if($lignepf[$i]['varj']<0) { $pdf->SetTextColor(220, 0, 0); }
	else {$pdf->SetTextColor( 0,220, 0); }
	$pdf->Cell($w[9],4,$lignepf[$i]['varj'],'LR',0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);		
	$pdf->Cell($w[10],4,$lignepf[$i]['plus_haut'],'LR',0,'R',$i%2);
	$pdf->Cell($w[11],4,$lignepf[$i]['plus_bas'],'LR',0,'R',$i%2);
	$pdf->Cell($w[12],4,$lignepf[$i]['ampl']."%",'LR',0,'R',$i%2);
	$pdf->Cell($w[13],4,$lignepf[$i]['volume'],'LR',0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);
	if($lignepf[$i]['evoj']<0) {	$pdf->SetTextColor(220, 0, 0); }
	$pdf->Cell($w[14],4,$lignepf[$i]['evoj'],'LR',0,'R',$i%2);
	$pdf->SetTextColor(0, 0, 0);
	$pdf->Cell($w[15],4,$lignepf[$i]['LPDIV'],'LR',0,'R',$i%2);
	$pdf->Cell($w[16],4,$lignepf[$i]['LPDDETACH'],'LR',0,'R',$i%2);
	$pdf->Ln();
	}
/* Liquidits */
$pdf->Cell($w[0],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[1]+$w[2]+$w[3]+$w[4],4,'Liquidits','LRB',0,'L',$i%2);
$pdf->SetTextColor(0, 0, 0);
if($porte_feuille['PFLIQUID']<0) {	$pdf->SetTextColor(220, 0, 0); }
$pdf->Cell($w[5],4,$porte_feuille['PFLIQUID'],'LRB',0,'R',$i%2);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell($w[6],4,'PMVL','LRB',0,'R',$i%2);
if($total['pmvL']<0) {	$pdf->SetTextColor(220, 0, 0); }
$pdf->Cell($w[7],4,$total['pmvL'],'LRB',0,'R',$i%2);
$pdf->Cell($w[8],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[9],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[10],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[11],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[12],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[13],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[14],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[15],4,'','LRB',0,'R',$i%2);
$pdf->Cell($w[16],4,'','LRB',0,'R',$i%2);
$pdf->Ln();

/* Totaux */
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('Arial','',10);
$pdf->Cell($w[0]+$w[1]+$w[2]+$w[3],4,'Total Portefeuille '.date('d/m/Y H:i:s'),'LRTB',0,'R',0);
$pdf->SetFont('Arial','B',10);
$pdf->Cell($w[4]+$w[5],4,$total['tpnow'],'LRTB',0,'R',0);

$pdf->SetFont('Arial','B',12);
$pdf->SetTextColor(0, 220, 0);
if($porte_feuille['PFV3112']<0) {	$pdf->SetTextColor(220, 0, 0); }
$pdf->Cell($w[6]+$w[7],12,$porte_feuille['PFV3112'].'%','LRTB',0,'C',0);
$pdf->SetTextColor(0, 0, 0);

$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell($w[8],12,'','LRT',0,'R',1);
$pdf->Cell($w[9]+$w[10]+$w[11]+$w[12],4,'Evolution du jour','LRTB',0,'R',0);

$pdf->SetTextColor(0, 220, 0);
$pdf->SetFont('Arial','B',10);
if($total['evoj']<0) {	$pdf->SetTextColor(220, 0, 0); }
$pdf->Cell($w[13]+$w[14],4,$total['evoj'],'LRTB',0,'R',0);

$pdf->SetFont('Arial','B',12);
$pdf->SetTextColor(0, 220, 0);
if($porte_feuille['PFVJ']<0) {	$pdf->SetTextColor(220, 0, 0); }
$pdf->Cell($w[15]+$w[16],12,$porte_feuille['PFVJ'].'%','LRTB',0,'C',0);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('Arial','',8);
$pdf->Cell(0,4,'','',0,'R',0);
$pdf->Ln();

$pdf->Cell($w[0]+$w[1]+$w[2]+$w[3],4,'Total Retraits ','LRTB',0,'R',0);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell($w[4]+$w[5],4,$total['tpretrait'],'LRTB',0,'R',0);

$pdf->Ln();

$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell($w[0]+$w[1]+$w[2]+$w[3],4,'Total Portefeuille au 31/12','LRTB',0,'R',0);
$pdf->SetFont('Arial','B',10);
$pdf->Cell($w[4]+$w[5],4,$porte_feuille['PF3112'],'LRTB',0,'R',0);
$pdf->Cell($w[6]+$w[7],0,'','',0,'R',0);
$pdf->Cell($w[8],4,'','LRB',0,'R',1);
$pdf->SetFont('Arial','',10);
$pdf->Cell($w[9]+$w[10]+$w[11]+$w[12],4,'Montant Portefeuille Veille','LRTB',0,'R',0);
$pdf->Cell($w[13]+$w[14],4,$total['tpveille'],'LRTB',0,'R',0);
$pdf->Cell($w[15]+$w[16],0,'','',0,'R',0);
$pdf->Ln();
}



$pdf->Output();
?>