<?php
set_time_limit(0);
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
if (ob_get_level() == 0) ob_start();
require_once("conf.inc.php");
require_once("functions.inc.php");
/*
Suivant l'heure si apres 19 heures..... on evite d'aller tout mettre   jour.
*/
$h = date('G');
if($h>=19){
$lignepf = get_SQL("SELECT T.TID, T.TTYPE, T.TURL, T.TDEV FROM titre T  WHERE T.TTYPE<>'G' AND T.TID IN (SELECT DISTINCT TID FROM ligne_portefeuille) 
	AND ( 
			( 
				(TCCLOTURE='(c)') AND (DATE_ADD(T.TCTIMESTAMP, INTERVAL 1 HOUR)<NOW() )
			)
		OR 
			(   
				(TCCLOTURE<>'(c)') AND  (DATE_ADD(T.TCTIMESTAMP, INTERVAL 5 MINUTE)<NOW())
			)
		)
		ORDER BY RAND() ");
}
else{
$lignepf = get_SQL("SELECT T.TID, T.TTYPE, T.TURL, T.TDEV FROM titre T  WHERE T.TTYPE NOT IN ('G','S') AND T.TID IN (SELECT DISTINCT TID FROM ligne_portefeuille) 
					AND (DATE_ADD(T.TCTIMESTAMP, INTERVAL 10 MINUTE)<NOW() ) ORDER BY RAND() ");
}

for($i=0;$i<count($lignepf);$i++)
	{
	$ligne = $lignepf[$i];
	$temp = Scan_Page($ligne['TURL'],$ligne['TTYPE']);
	$ligne['ampl'] = 0;
	if ($temp['plus_bas']!=0)
		{
		$ligne['ampl'] = sprintf('%.2f',($temp['plus_haut']-$temp['plus_bas'])*100/$temp['plus_bas']);
		}
	if ($ligne['TDEV']=='EUR')
		{
		$ligne['cours'] = sprintf('%.2f',$temp['cours']);
		$ligne['cloture'] = $temp['cloture'];
		$ligne['volume'] = $temp['volume'];
		$ligne['varj'] = $temp['varj'];
		$ligne['plus_haut'] = $temp['plus_haut'];
		$ligne['plus_bas'] = $temp['plus_bas'];
		$ligne['time'] = round($temp['time'],4);
		}	
	if ($ligne['TDEV']=='GBX')
		{
		$taux = 1/gbp_taux()/100;
		$ligne['cours'] = sprintf('%.2f',$taux*$temp['cours']);
		$ligne['cloture'] = $temp['cloture'];
		$ligne['volume'] = $temp['volume'];
		$ligne['varj'] = $temp['varj'];
		$ligne['plus_haut'] = sprintf('%.2f',$taux*$temp['plus_haut']);
		$ligne['plus_bas'] = sprintf('%.2f',$taux*$temp['plus_bas']);
		$ligne['time'] = round($temp['time'],4);
		}
	if ($ligne['TDEV']=='GBP')
		{
		$taux = 1/gbp_taux();
		$ligne['cours'] = sprintf('%.2f',$taux*$temp['cours']);
		$ligne['cloture'] = $temp['cloture'];
		$ligne['volume'] = $temp['volume'];
		$ligne['varj'] = $temp['varj'];
		$ligne['plus_haut'] = sprintf('%.2f',$taux*$temp['plus_haut']);
		$ligne['plus_bas'] = sprintf('%.2f',$taux*$temp['plus_bas']);
		$ligne['time'] = round($temp['time'],4);
		}
	if ($ligne['TDEV']=='USD')
		{
		$taux = 1/usd_taux();
		$ligne['cours'] = sprintf('%.2f',$taux*$temp['cours']);
		$ligne['cloture'] = $temp['cloture'];
		$ligne['volume'] = $temp['volume'];
		$ligne['varj'] = $temp['varj'];
		$ligne['plus_haut'] = sprintf('%.2f',$taux*$temp['plus_haut']);
		$ligne['plus_bas'] = sprintf('%.2f',$taux*$temp['plus_bas']);
		$ligne['time'] = round($temp['time'],4);
		}
	
	print "|\r\n";
	flush();
	update_titre($ligne);
	usleep(50000);
	$temps = rand(0,3);
	sleep($temps);
	}
ob_end_flush();
?>